<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * @category  BSS
 * @package   Bss_FastOrder
 * @author    Extension Team
 * @copyright Copyright (c) 2017-2020 BSS Commerce Co. ( http://bsscommerce.com )
 * @license   http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\FastOrder\Model\Config\Backend\Mini;

/**
 * Class NumLine
 *
 * @package Bss\FastOrder\Model\Config\Backend\Mini
 */
class NumLine extends \Magento\Framework\App\Config\Value
{
    /**
     * Check number of line mini. If number > 10 convert 10
     *
     * @return NumLine|void
     */
    public function beforeSave()
    {
        $value = $this->getValue();
        if ($value > 10) {
            $this->setValue(10);
        }
        parent::beforeSave();
    }
}
