<?php

namespace Amasty\Xsearch\Controller\Adminhtml\Activity;

use Magento\Framework\Controller\ResultFactory;

class Index extends \Magento\Backend\App\Action
{
    /**
     * Index action
     *
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
        $resultPage->setActiveMenu('Amasty_Xsearch::activity');
        $resultPage->getConfig()->getTitle()->prepend(__('Recent Activity'));
        $resultPage->addBreadcrumb(__('Search Analytics'), __('Recent Activity'));

        return $resultPage;
    }

    /**
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Amasty_Xsearch::activity');
    }
}
